/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.net.URI;
import java.net.URISyntaxException;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspParsedUri;
import jpcsp.HLE.modules.sceHttp;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceParseUri
extends HLEModule {
    public static Logger log = Modules.getLogger("sceParseUri");
    private static final boolean[] escapeCharTable = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private static final int[] hexTable = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    protected int getHexValue(int hexChar) {
        if (hexChar >= 48 && hexChar <= 57) {
            return hexChar - 48;
        }
        if (hexChar >= 65 && hexChar <= 70) {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 97 && hexChar <= 102) {
            return hexChar - 97 + 10;
        }
        return 0;
    }

    private int addString(TPointer workArea, int workAreaSize, int offset, String s) {
        int length;
        if (s == null) {
            s = "";
        }
        if (offset + (length = s.length() + 1) > workAreaSize && (length = workAreaSize - offset) <= 0) {
            return offset;
        }
        workArea.setStringNZ(offset, length, s);
        return offset + length;
    }

    private String getUriComponent(int componentAddr, int flags, int flag) {
        if ((flags & flag) == 0 || componentAddr == 0) {
            return null;
        }
        return Utilities.readStringZ(componentAddr);
    }

    @HLEFunction(nid=1451563209, version=150)
    public int sceUriParse(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=44, usage=BufferInfo.Usage.out) TPointer parsedUriArea, PspString url, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer workArea, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 workAreaSizeAddr, int workAreaSize) {
        String query;
        int userInfoColon;
        String userInfo;
        URI uri;
        if (parsedUriArea.isNull() || workArea.isNull()) {
            workAreaSizeAddr.setValue(url.getString().length() + 7);
            return 0;
        }
        String urlString = sceHttp.patchUrl(url.getString());
        if (!urlString.equals(url.getString())) {
            log.info((Object)String.format("sceUriParse patched URL '%s' into '%s'", url.getString(), urlString));
        }
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            log.error((Object)"parsedUriArea", (Throwable)e);
            return -1;
        }
        String userInfoUserName = userInfo = uri.getUserInfo();
        String userInfoPassword = "";
        if (userInfo != null && (userInfoColon = userInfo.indexOf(":")) >= 0) {
            userInfoUserName = userInfo.substring(0, userInfoColon);
            userInfoPassword = userInfo.substring(userInfoColon + 1);
        }
        if ((query = uri.getQuery()) != null && query.length() > 0) {
            query = "?" + query;
        }
        pspParsedUri parsedUri = new pspParsedUri();
        int offset = 0;
        parsedUri.noSlash = uri.getSchemeSpecificPart() != null && uri.getSchemeSpecificPart().startsWith("//") ? 0 : 1;
        parsedUri.schemeAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, uri.getScheme());
        parsedUri.userInfoUserNameAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, userInfoUserName);
        parsedUri.userInfoPasswordAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, userInfoPassword);
        parsedUri.hostAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, uri.getHost());
        parsedUri.pathAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, uri.getPath());
        parsedUri.queryAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, query);
        parsedUri.fragmentAddr = workArea.getAddress() + offset;
        offset = this.addString(workArea, workAreaSize, offset, uri.getFragment());
        parsedUri.port = uri.getPort() < 0 ? ("http".equals(uri.getScheme()) ? 80 : ("https".equals(uri.getScheme()) ? 443 : 0)) : uri.getPort();
        workAreaSizeAddr.setValue(offset);
        parsedUri.write(parsedUriArea);
        return 0;
    }

    @HLEFunction(nid=2128812207, version=150)
    public int sceUriBuild(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer workArea, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 workAreaSizeAddr, int workAreaSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=44, usage=BufferInfo.Usage.in) TPointer parsedUriAddr, int flags) {
        pspParsedUri parsedUri = new pspParsedUri();
        parsedUri.read(parsedUriAddr);
        String scheme = this.getUriComponent(parsedUri.schemeAddr, flags, 1);
        String userInfoUserName = this.getUriComponent(parsedUri.userInfoUserNameAddr, flags, 16);
        String userInfoPassword = this.getUriComponent(parsedUri.userInfoPasswordAddr, flags, 32);
        String host = this.getUriComponent(parsedUri.hostAddr, flags, 2);
        String path = this.getUriComponent(parsedUri.pathAddr, flags, 8);
        String query = this.getUriComponent(parsedUri.queryAddr, flags, 64);
        String fragment = this.getUriComponent(parsedUri.fragmentAddr, flags, 128);
        int port = (flags & 4) != 0 ? parsedUri.port : -1;
        String uri = "";
        if (scheme != null && scheme.length() > 0) {
            uri = uri + scheme + ":";
        }
        if (parsedUri.noSlash == 0) {
            uri = uri + "//";
        }
        if (userInfoUserName != null) {
            uri = uri + userInfoUserName;
        }
        if (userInfoPassword != null && userInfoPassword.length() > 0) {
            uri = uri + ":" + userInfoPassword;
        }
        if (host != null) {
            uri = uri + host;
        }
        if (port > 0) {
            int defaultPort = -1;
            if (parsedUri.schemeAddr != 0) {
                String protocol = Utilities.readStringZ(parsedUri.schemeAddr);
                defaultPort = Utilities.getDefaultPortForProtocol(protocol);
            }
            if (port > 0 && port != defaultPort) {
                uri = uri + ":" + port;
            }
        }
        if (path != null) {
            uri = uri + path;
        }
        if (query != null) {
            uri = uri + query;
        }
        if (fragment != null) {
            uri = uri + fragment;
        }
        if (workArea.isNotNull()) {
            workArea.setStringNZ(workAreaSize, uri);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceUriBuild returning '%s'", uri));
            }
        }
        workAreaSizeAddr.setValue(uri.length() + 1);
        return 0;
    }

    @HLEFunction(nid=1240027372, version=150)
    public int sceUriEscape(@CanBeNull TPointer escapedAddr, @CanBeNull TPointer32 escapedLengthAddr, int escapedBufferLength, TPointer source) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(source.getAddress(), 1);
        IMemoryWriter memoryWriter = null;
        if (escapedAddr.isNotNull()) {
            memoryWriter = MemoryWriter.getMemoryWriter(escapedAddr.getAddress(), escapedBufferLength, 1);
        }
        int escapedLength = 0;
        while (true) {
            int c;
            if ((c = memoryReader.readNext()) == 0) {
                if (escapedAddr.isNotNull() && escapedLength < escapedBufferLength) {
                    memoryWriter.writeNext(c);
                }
                ++escapedLength;
                break;
            }
            if (escapeCharTable[c]) {
                if (escapedAddr.isNotNull()) {
                    if (escapedLength + 3 > escapedBufferLength) break;
                    memoryWriter.writeNext(37);
                    memoryWriter.writeNext(hexTable[c >> 4]);
                    memoryWriter.writeNext(hexTable[c & 0xF]);
                }
                escapedLength += 3;
                continue;
            }
            if (escapedAddr.isNotNull()) {
                if (escapedLength + 1 > escapedBufferLength) break;
                memoryWriter.writeNext(c);
            }
            ++escapedLength;
        }
        if (memoryWriter != null) {
            memoryWriter.flush();
        }
        escapedLengthAddr.setValue(escapedLength);
        return 0;
    }

    @HLEFunction(nid=103526526, version=150)
    public int sceUriUnescape(@CanBeNull TPointer unescapedAddr, @CanBeNull TPointer32 unescapedLengthAddr, int unescapedBufferLength, TPointer source) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(source.getAddress(), 1);
        IMemoryWriter memoryWriter = null;
        if (unescapedAddr.isNotNull()) {
            memoryWriter = MemoryWriter.getMemoryWriter(unescapedAddr.getAddress(), unescapedBufferLength, 1);
        }
        int unescapedLength = 0;
        while (true) {
            int c;
            if ((c = memoryReader.readNext()) == 0) {
                if (unescapedAddr.isNotNull() && unescapedLength < unescapedBufferLength) {
                    memoryWriter.writeNext(c);
                }
                ++unescapedLength;
                break;
            }
            if (unescapedAddr.isNotNull()) {
                if (unescapedLength + 1 > unescapedBufferLength) break;
                if (c == 37) {
                    int hex1 = memoryReader.readNext();
                    int hex2 = memoryReader.readNext();
                    c = (this.getHexValue(hex1) << 4) + this.getHexValue(hex2);
                }
                memoryWriter.writeNext(c);
            }
            ++unescapedLength;
        }
        if (memoryWriter != null) {
            memoryWriter.flush();
        }
        unescapedLengthAddr.setValue(unescapedLength);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2004506750, version=150)
    public int sceUriSweepPath(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer outputAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer inputAddr, int length) {
        outputAddr.memcpy(inputAddr.getAddress(), length);
        return 0;
    }
}

